package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Session(
    sessionId: Option[String] = None,
    streamUrl: Option[String] = None,
    tokenValue: Option[SensitiveString] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Session = {
    import Session.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Session
      .builder()
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(streamUrl.map(value => value: java.lang.String))(
        _.streamUrl
      )
      .optionallyWith(
        tokenValue.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.tokenValue)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Session.ReadOnly =
    zio.aws.ecs.model.Session.wrap(buildAwsValue())
}
object Session {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Session] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Session = zio.aws.ecs.model.Session(
      sessionId.map(value => value),
      streamUrl.map(value => value),
      tokenValue.map(value => value)
    )
    def sessionId: Option[String]
    def streamUrl: Option[String]
    def tokenValue: Option[SensitiveString]
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getStreamUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamUrl", streamUrl)
    def getTokenValue: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("tokenValue", tokenValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Session
  ) extends zio.aws.ecs.model.Session.ReadOnly {
    override val sessionId: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
    override val streamUrl: Option[String] =
      scala.Option(impl.streamUrl()).map(value => value: String)
    override val tokenValue: Option[SensitiveString] = scala
      .Option(impl.tokenValue())
      .map(value => zio.aws.ecs.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Session
  ): zio.aws.ecs.model.Session.ReadOnly = new Wrapper(impl)
}
