package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.ecs.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.SortOrder
  ): zio.aws.ecs.model.SortOrder = value match {
    case software.amazon.awssdk.services.ecs.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.SortOrder.ASC =>
      val r = ASC
      r
    case software.amazon.awssdk.services.ecs.model.SortOrder.DESC =>
      val r = DESC
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.SortOrder {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SortOrder =
      software.amazon.awssdk.services.ecs.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASC extends zio.aws.ecs.model.SortOrder {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SortOrder =
      software.amazon.awssdk.services.ecs.model.SortOrder.ASC
  }
  case object DESC extends zio.aws.ecs.model.SortOrder {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SortOrder =
      software.amazon.awssdk.services.ecs.model.SortOrder.DESC
  }
}
