package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartTaskResponse(
    tasks: Option[Iterable[zio.aws.ecs.model.Task]] = None,
    failures: Option[Iterable[zio.aws.ecs.model.Failure]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.StartTaskResponse = {
    import StartTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.StartTaskResponse
      .builder()
      .optionallyWith(
        tasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tasks)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.StartTaskResponse.ReadOnly =
    zio.aws.ecs.model.StartTaskResponse.wrap(buildAwsValue())
}
object StartTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.StartTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.StartTaskResponse =
      zio.aws.ecs.model.StartTaskResponse(
        tasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tasks: Option[List[zio.aws.ecs.model.Task.ReadOnly]]
    def failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getTasks: ZIO[Any, AwsError, List[zio.aws.ecs.model.Task.ReadOnly]] =
      AwsError.unwrapOptionField("tasks", tasks)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.StartTaskResponse
  ) extends zio.aws.ecs.model.StartTaskResponse.ReadOnly {
    override val tasks: Option[List[zio.aws.ecs.model.Task.ReadOnly]] = scala
      .Option(impl.tasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Task.wrap(item)
        }.toList
      )
    override val failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      scala
        .Option(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.StartTaskResponse
  ): zio.aws.ecs.model.StartTaskResponse.ReadOnly = new Wrapper(impl)
}
