package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SubmitAttachmentStateChangesRequest(
    cluster: Option[String] = None,
    attachments: Iterable[zio.aws.ecs.model.AttachmentStateChange]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest = {
    import SubmitAttachmentStateChangesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .attachments(attachments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.SubmitAttachmentStateChangesRequest.ReadOnly =
    zio.aws.ecs.model.SubmitAttachmentStateChangesRequest.wrap(buildAwsValue())
}
object SubmitAttachmentStateChangesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SubmitAttachmentStateChangesRequest =
      zio.aws.ecs.model.SubmitAttachmentStateChangesRequest(
        cluster.map(value => value),
        attachments.map { item =>
          item.asEditable
        }
      )
    def cluster: Option[String]
    def attachments: List[zio.aws.ecs.model.AttachmentStateChange.ReadOnly]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getAttachments: ZIO[Any, Nothing, List[
      zio.aws.ecs.model.AttachmentStateChange.ReadOnly
    ]] = ZIO.succeed(attachments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest
  ) extends zio.aws.ecs.model.SubmitAttachmentStateChangesRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val attachments
        : List[zio.aws.ecs.model.AttachmentStateChange.ReadOnly] = impl
      .attachments()
      .asScala
      .map { item =>
        zio.aws.ecs.model.AttachmentStateChange.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest
  ): zio.aws.ecs.model.SubmitAttachmentStateChangesRequest.ReadOnly =
    new Wrapper(impl)
}
