package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SubmitTaskStateChangeResponse(
    acknowledgment: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeResponse = {
    import SubmitTaskStateChangeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeResponse
      .builder()
      .optionallyWith(acknowledgment.map(value => value: java.lang.String))(
        _.acknowledgment
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.SubmitTaskStateChangeResponse.ReadOnly =
    zio.aws.ecs.model.SubmitTaskStateChangeResponse.wrap(buildAwsValue())
}
object SubmitTaskStateChangeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SubmitTaskStateChangeResponse =
      zio.aws.ecs.model
        .SubmitTaskStateChangeResponse(acknowledgment.map(value => value))
    def acknowledgment: Option[String]
    def getAcknowledgment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acknowledgment", acknowledgment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeResponse
  ) extends zio.aws.ecs.model.SubmitTaskStateChangeResponse.ReadOnly {
    override val acknowledgment: Option[String] =
      scala.Option(impl.acknowledgment()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeResponse
  ): zio.aws.ecs.model.SubmitTaskStateChangeResponse.ReadOnly = new Wrapper(
    impl
  )
}
