package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait TargetType {
  def unwrap: software.amazon.awssdk.services.ecs.model.TargetType
}
object TargetType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.TargetType
  ): zio.aws.ecs.model.TargetType = value match {
    case software.amazon.awssdk.services.ecs.model.TargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.TargetType.CONTAINER_INSTANCE =>
      val r = `container-instance`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.ecs.model.TargetType =
      software.amazon.awssdk.services.ecs.model.TargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object `container-instance` extends zio.aws.ecs.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.ecs.model.TargetType =
      software.amazon.awssdk.services.ecs.model.TargetType.CONTAINER_INSTANCE
  }
}
