package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait TaskDefinitionField {
  def unwrap: software.amazon.awssdk.services.ecs.model.TaskDefinitionField
}
object TaskDefinitionField {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.TaskDefinitionField
  ): zio.aws.ecs.model.TaskDefinitionField = value match {
    case software.amazon.awssdk.services.ecs.model.TaskDefinitionField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.TaskDefinitionField.TAGS =>
      val r = TAGS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.TaskDefinitionField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskDefinitionField =
      software.amazon.awssdk.services.ecs.model.TaskDefinitionField.UNKNOWN_TO_SDK_VERSION
  }
  case object TAGS extends zio.aws.ecs.model.TaskDefinitionField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskDefinitionField =
      software.amazon.awssdk.services.ecs.model.TaskDefinitionField.TAGS
  }
}
