package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait TransportProtocol {
  def unwrap: software.amazon.awssdk.services.ecs.model.TransportProtocol
}
object TransportProtocol {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.TransportProtocol
  ): zio.aws.ecs.model.TransportProtocol = value match {
    case software.amazon.awssdk.services.ecs.model.TransportProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.TransportProtocol.TCP =>
      val r = tcp
      r
    case software.amazon.awssdk.services.ecs.model.TransportProtocol.UDP =>
      val r = udp
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.TransportProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TransportProtocol =
      software.amazon.awssdk.services.ecs.model.TransportProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object tcp extends zio.aws.ecs.model.TransportProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TransportProtocol =
      software.amazon.awssdk.services.ecs.model.TransportProtocol.TCP
  }
  case object udp extends zio.aws.ecs.model.TransportProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TransportProtocol =
      software.amazon.awssdk.services.ecs.model.TransportProtocol.UDP
  }
}
