package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait UlimitName {
  def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName
}
object UlimitName {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.UlimitName
  ): zio.aws.ecs.model.UlimitName = value match {
    case software.amazon.awssdk.services.ecs.model.UlimitName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.CORE =>
      val r = core
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.CPU =>
      val r = cpu
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.DATA =>
      val r = data
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.FSIZE =>
      val r = fsize
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.LOCKS =>
      val r = locks
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.MEMLOCK =>
      val r = memlock
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.MSGQUEUE =>
      val r = msgqueue
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.NICE =>
      val r = nice
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.NOFILE =>
      val r = nofile
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.NPROC =>
      val r = nproc
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.RSS =>
      val r = rss
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.RTPRIO =>
      val r = rtprio
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.RTTIME =>
      val r = rttime
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.SIGPENDING =>
      val r = sigpending
      r
    case software.amazon.awssdk.services.ecs.model.UlimitName.STACK =>
      val r = stack
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.UNKNOWN_TO_SDK_VERSION
  }
  case object core extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.CORE
  }
  case object cpu extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.CPU
  }
  case object data extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.DATA
  }
  case object fsize extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.FSIZE
  }
  case object locks extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.LOCKS
  }
  case object memlock extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.MEMLOCK
  }
  case object msgqueue extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.MSGQUEUE
  }
  case object nice extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.NICE
  }
  case object nofile extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.NOFILE
  }
  case object nproc extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.NPROC
  }
  case object rss extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.RSS
  }
  case object rtprio extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.RTPRIO
  }
  case object rttime extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.RTTIME
  }
  case object sigpending extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.SIGPENDING
  }
  case object stack extends zio.aws.ecs.model.UlimitName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.UlimitName =
      software.amazon.awssdk.services.ecs.model.UlimitName.STACK
  }
}
