package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateCapacityProviderRequest(
    name: String,
    autoScalingGroupProvider: zio.aws.ecs.model.AutoScalingGroupProviderUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest = {
    import UpdateCapacityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest
      .builder()
      .name(name: java.lang.String)
      .autoScalingGroupProvider(autoScalingGroupProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateCapacityProviderRequest.ReadOnly =
    zio.aws.ecs.model.UpdateCapacityProviderRequest.wrap(buildAwsValue())
}
object UpdateCapacityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateCapacityProviderRequest =
      zio.aws.ecs.model.UpdateCapacityProviderRequest(
        name,
        autoScalingGroupProvider.asEditable
      )
    def name: String
    def autoScalingGroupProvider
        : zio.aws.ecs.model.AutoScalingGroupProviderUpdate.ReadOnly
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getAutoScalingGroupProvider: ZIO[
      Any,
      Nothing,
      zio.aws.ecs.model.AutoScalingGroupProviderUpdate.ReadOnly
    ] = ZIO.succeed(autoScalingGroupProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest
  ) extends zio.aws.ecs.model.UpdateCapacityProviderRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val autoScalingGroupProvider
        : zio.aws.ecs.model.AutoScalingGroupProviderUpdate.ReadOnly =
      zio.aws.ecs.model.AutoScalingGroupProviderUpdate
        .wrap(impl.autoScalingGroupProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest
  ): zio.aws.ecs.model.UpdateCapacityProviderRequest.ReadOnly = new Wrapper(
    impl
  )
}
