package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateClusterSettingsRequest(
    cluster: String,
    settings: Iterable[zio.aws.ecs.model.ClusterSetting]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest = {
    import UpdateClusterSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .settings(settings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateClusterSettingsRequest.ReadOnly =
    zio.aws.ecs.model.UpdateClusterSettingsRequest.wrap(buildAwsValue())
}
object UpdateClusterSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateClusterSettingsRequest =
      zio.aws.ecs.model.UpdateClusterSettingsRequest(
        cluster,
        settings.map { item =>
          item.asEditable
        }
      )
    def cluster: String
    def settings: List[zio.aws.ecs.model.ClusterSetting.ReadOnly]
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getSettings
        : ZIO[Any, Nothing, List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      ZIO.succeed(settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest
  ) extends zio.aws.ecs.model.UpdateClusterSettingsRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val settings: List[zio.aws.ecs.model.ClusterSetting.ReadOnly] =
      impl
        .settings()
        .asScala
        .map { item =>
          zio.aws.ecs.model.ClusterSetting.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest
  ): zio.aws.ecs.model.UpdateClusterSettingsRequest.ReadOnly = new Wrapper(impl)
}
