package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class DescribeAccountPreferencesResponse(
    resourceIdPreference: Option[zio.aws.efs.model.ResourceIdPreference] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse = {
    import DescribeAccountPreferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse
      .builder()
      .optionallyWith(resourceIdPreference.map(value => value.buildAwsValue()))(
        _.resourceIdPreference
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DescribeAccountPreferencesResponse.ReadOnly =
    zio.aws.efs.model.DescribeAccountPreferencesResponse.wrap(buildAwsValue())
}
object DescribeAccountPreferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeAccountPreferencesResponse =
      zio.aws.efs.model.DescribeAccountPreferencesResponse(
        resourceIdPreference.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def resourceIdPreference
        : Option[zio.aws.efs.model.ResourceIdPreference.ReadOnly]
    def nextToken: Option[Token]
    def getResourceIdPreference
        : ZIO[Any, AwsError, zio.aws.efs.model.ResourceIdPreference.ReadOnly] =
      AwsError.unwrapOptionField("resourceIdPreference", resourceIdPreference)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse
  ) extends zio.aws.efs.model.DescribeAccountPreferencesResponse.ReadOnly {
    override val resourceIdPreference
        : Option[zio.aws.efs.model.ResourceIdPreference.ReadOnly] = scala
      .Option(impl.resourceIdPreference())
      .map(value => zio.aws.efs.model.ResourceIdPreference.wrap(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse
  ): zio.aws.efs.model.DescribeAccountPreferencesResponse.ReadOnly =
    new Wrapper(impl)
}
