package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class DescribeBackupPolicyRequest(fileSystemId: FileSystemId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest = {
    import DescribeBackupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeBackupPolicyRequest.ReadOnly =
    zio.aws.efs.model.DescribeBackupPolicyRequest.wrap(buildAwsValue())
}
object DescribeBackupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeBackupPolicyRequest =
      zio.aws.efs.model.DescribeBackupPolicyRequest(fileSystemId)
    def fileSystemId: FileSystemId
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest
  ) extends zio.aws.efs.model.DescribeBackupPolicyRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest
  ): zio.aws.efs.model.DescribeBackupPolicyRequest.ReadOnly = new Wrapper(impl)
}
