package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemPolicyRequest(fileSystemId: FileSystemId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest = {
    import DescribeFileSystemPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeFileSystemPolicyRequest.ReadOnly =
    zio.aws.efs.model.DescribeFileSystemPolicyRequest.wrap(buildAwsValue())
}
object DescribeFileSystemPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeFileSystemPolicyRequest =
      zio.aws.efs.model.DescribeFileSystemPolicyRequest(fileSystemId)
    def fileSystemId: FileSystemId
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest
  ) extends zio.aws.efs.model.DescribeFileSystemPolicyRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest
  ): zio.aws.efs.model.DescribeFileSystemPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
