package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class DescribeLifecycleConfigurationRequest(
    fileSystemId: FileSystemId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest = {
    import DescribeLifecycleConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DescribeLifecycleConfigurationRequest.ReadOnly =
    zio.aws.efs.model.DescribeLifecycleConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeLifecycleConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeLifecycleConfigurationRequest =
      zio.aws.efs.model.DescribeLifecycleConfigurationRequest(fileSystemId)
    def fileSystemId: FileSystemId
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest
  ) extends zio.aws.efs.model.DescribeLifecycleConfigurationRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest
  ): zio.aws.efs.model.DescribeLifecycleConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
