package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.SecurityGroup
import scala.jdk.CollectionConverters._
final case class DescribeMountTargetSecurityGroupsResponse(
    securityGroups: Iterable[SecurityGroup]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse = {
    import DescribeMountTargetSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse
      .builder()
      .securityGroups(securityGroups.map { item =>
        SecurityGroup.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.ReadOnly =
    zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeMountTargetSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse =
      zio.aws.efs.model
        .DescribeMountTargetSecurityGroupsResponse(securityGroups)
    def securityGroups: List[SecurityGroup]
    def getSecurityGroups: ZIO[Any, Nothing, List[SecurityGroup]] =
      ZIO.succeed(securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse
  ) extends zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.ReadOnly {
    override val securityGroups: List[SecurityGroup] = impl
      .securityGroups()
      .asScala
      .map { item =>
        zio.aws.efs.model.primitives.SecurityGroup(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse
  ): zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
