package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{KmsKeyId, AvailabilityZoneName, RegionName}
import scala.jdk.CollectionConverters._
final case class DestinationToCreate(
    region: Option[RegionName] = None,
    availabilityZoneName: Option[AvailabilityZoneName] = None,
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DestinationToCreate = {
    import DestinationToCreate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DestinationToCreate
      .builder()
      .optionallyWith(
        region.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        availabilityZoneName.map(value =>
          AvailabilityZoneName.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneName)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DestinationToCreate.ReadOnly =
    zio.aws.efs.model.DestinationToCreate.wrap(buildAwsValue())
}
object DestinationToCreate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DestinationToCreate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DestinationToCreate =
      zio.aws.efs.model.DestinationToCreate(
        region.map(value => value),
        availabilityZoneName.map(value => value),
        kmsKeyId.map(value => value)
      )
    def region: Option[RegionName]
    def availabilityZoneName: Option[AvailabilityZoneName]
    def kmsKeyId: Option[KmsKeyId]
    def getRegion: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("region", region)
    def getAvailabilityZoneName: ZIO[Any, AwsError, AvailabilityZoneName] =
      AwsError.unwrapOptionField("availabilityZoneName", availabilityZoneName)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DestinationToCreate
  ) extends zio.aws.efs.model.DestinationToCreate.ReadOnly {
    override val region: Option[RegionName] = scala
      .Option(impl.region())
      .map(value => zio.aws.efs.model.primitives.RegionName(value))
    override val availabilityZoneName: Option[AvailabilityZoneName] = scala
      .Option(impl.availabilityZoneName())
      .map(value => zio.aws.efs.model.primitives.AvailabilityZoneName(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.efs.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DestinationToCreate
  ): zio.aws.efs.model.DestinationToCreate.ReadOnly = new Wrapper(impl)
}
