package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{SecurityGroup, MountTargetId}
import scala.jdk.CollectionConverters._
final case class ModifyMountTargetSecurityGroupsRequest(
    mountTargetId: MountTargetId,
    securityGroups: Option[Iterable[SecurityGroup]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest = {
    import ModifyMountTargetSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest
      .builder()
      .mountTargetId(MountTargetId.unwrap(mountTargetId): java.lang.String)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest.ReadOnly =
    zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest
      .wrap(buildAwsValue())
}
object ModifyMountTargetSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest =
      zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest(
        mountTargetId,
        securityGroups.map(value => value)
      )
    def mountTargetId: MountTargetId
    def securityGroups: Option[List[SecurityGroup]]
    def getMountTargetId: ZIO[Any, Nothing, MountTargetId] =
      ZIO.succeed(mountTargetId)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroup]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest
  ) extends zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest.ReadOnly {
    override val mountTargetId: MountTargetId =
      zio.aws.efs.model.primitives.MountTargetId(impl.mountTargetId())
    override val securityGroups: Option[List[SecurityGroup]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.efs.model.primitives.SecurityGroup(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest
  ): zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
