package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait PerformanceMode {
  def unwrap: software.amazon.awssdk.services.efs.model.PerformanceMode
}
object PerformanceMode {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.PerformanceMode
  ): zio.aws.efs.model.PerformanceMode = value match {
    case software.amazon.awssdk.services.efs.model.PerformanceMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.PerformanceMode.GENERAL_PURPOSE =>
      val r = generalPurpose
      r
    case software.amazon.awssdk.services.efs.model.PerformanceMode.MAX_IO =>
      val r = maxIO
      r
  }
  case object unknownToSdkVersion extends zio.aws.efs.model.PerformanceMode {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.PerformanceMode =
      software.amazon.awssdk.services.efs.model.PerformanceMode.UNKNOWN_TO_SDK_VERSION
  }
  case object generalPurpose extends zio.aws.efs.model.PerformanceMode {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.PerformanceMode =
      software.amazon.awssdk.services.efs.model.PerformanceMode.GENERAL_PURPOSE
  }
  case object maxIO extends zio.aws.efs.model.PerformanceMode {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.PerformanceMode =
      software.amazon.awssdk.services.efs.model.PerformanceMode.MAX_IO
  }
}
