package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{
  BypassPolicyLockoutSafetyCheck,
  Policy,
  FileSystemId
}
import scala.jdk.CollectionConverters._
final case class PutFileSystemPolicyRequest(
    fileSystemId: FileSystemId,
    policy: Policy,
    bypassPolicyLockoutSafetyCheck: Option[BypassPolicyLockoutSafetyCheck] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest = {
    import PutFileSystemPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .optionallyWith(
        bypassPolicyLockoutSafetyCheck.map(value =>
          BypassPolicyLockoutSafetyCheck.unwrap(value): java.lang.Boolean
        )
      )(_.bypassPolicyLockoutSafetyCheck)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PutFileSystemPolicyRequest.ReadOnly =
    zio.aws.efs.model.PutFileSystemPolicyRequest.wrap(buildAwsValue())
}
object PutFileSystemPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PutFileSystemPolicyRequest =
      zio.aws.efs.model.PutFileSystemPolicyRequest(
        fileSystemId,
        policy,
        bypassPolicyLockoutSafetyCheck.map(value => value)
      )
    def fileSystemId: FileSystemId
    def policy: Policy
    def bypassPolicyLockoutSafetyCheck: Option[BypassPolicyLockoutSafetyCheck]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
    def getBypassPolicyLockoutSafetyCheck
        : ZIO[Any, AwsError, BypassPolicyLockoutSafetyCheck] =
      AwsError.unwrapOptionField(
        "bypassPolicyLockoutSafetyCheck",
        bypassPolicyLockoutSafetyCheck
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest
  ) extends zio.aws.efs.model.PutFileSystemPolicyRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val policy: Policy =
      zio.aws.efs.model.primitives.Policy(impl.policy())
    override val bypassPolicyLockoutSafetyCheck
        : Option[BypassPolicyLockoutSafetyCheck] = scala
      .Option(impl.bypassPolicyLockoutSafetyCheck())
      .map(value =>
        zio.aws.efs.model.primitives.BypassPolicyLockoutSafetyCheck(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest
  ): zio.aws.efs.model.PutFileSystemPolicyRequest.ReadOnly = new Wrapper(impl)
}
