package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceId: ResourceId,
    tags: Iterable[zio.aws.efs.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.TagResourceRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.TagResourceRequest.ReadOnly =
    zio.aws.efs.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.TagResourceRequest =
      zio.aws.efs.model.TagResourceRequest(
        resourceId,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceId: ResourceId
    def tags: List[zio.aws.efs.model.Tag.ReadOnly]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTags: ZIO[Any, Nothing, List[zio.aws.efs.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.TagResourceRequest
  ) extends zio.aws.efs.model.TagResourceRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.efs.model.primitives.ResourceId(impl.resourceId())
    override val tags: List[zio.aws.efs.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.efs.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.TagResourceRequest
  ): zio.aws.efs.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
