package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait ThroughputMode {
  def unwrap: software.amazon.awssdk.services.efs.model.ThroughputMode
}
object ThroughputMode {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.ThroughputMode
  ): zio.aws.efs.model.ThroughputMode = value match {
    case software.amazon.awssdk.services.efs.model.ThroughputMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.ThroughputMode.BURSTING =>
      val r = bursting
      r
    case software.amazon.awssdk.services.efs.model.ThroughputMode.PROVISIONED =>
      val r = provisioned
      r
  }
  case object unknownToSdkVersion extends zio.aws.efs.model.ThroughputMode {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ThroughputMode =
      software.amazon.awssdk.services.efs.model.ThroughputMode.UNKNOWN_TO_SDK_VERSION
  }
  case object bursting extends zio.aws.efs.model.ThroughputMode {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ThroughputMode =
      software.amazon.awssdk.services.efs.model.ThroughputMode.BURSTING
  }
  case object provisioned extends zio.aws.efs.model.ThroughputMode {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ThroughputMode =
      software.amazon.awssdk.services.efs.model.ThroughputMode.PROVISIONED
  }
}
