package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait TransitionToPrimaryStorageClassRules {
  def unwrap: software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules
}
object TransitionToPrimaryStorageClassRules {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules
  ): zio.aws.efs.model.TransitionToPrimaryStorageClassRules = value match {
    case software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules.AFTER_1_ACCESS =>
      val r = AFTER_1_ACCESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.efs.model.TransitionToPrimaryStorageClassRules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules =
      software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules.UNKNOWN_TO_SDK_VERSION
  }
  case object AFTER_1_ACCESS
      extends zio.aws.efs.model.TransitionToPrimaryStorageClassRules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules =
      software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules.AFTER_1_ACCESS
  }
}
