package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.{TagKey, ResourceId}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceId: ResourceId,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.UntagResourceRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.UntagResourceRequest.ReadOnly =
    zio.aws.efs.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.UntagResourceRequest =
      zio.aws.efs.model.UntagResourceRequest(resourceId, tagKeys)
    def resourceId: ResourceId
    def tagKeys: List[TagKey]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.UntagResourceRequest
  ) extends zio.aws.efs.model.UntagResourceRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.efs.model.primitives.ResourceId(impl.resourceId())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.efs.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.UntagResourceRequest
  ): zio.aws.efs.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
