package zio.aws.efs
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.efs.model.primitives.{TagKey, SecurityGroup, Gid}
import zio.aws.efs.model.primitives.MaxItems.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessPointArn extends Subtype[String]
    type AccessPointArn = zio.aws.efs.model.primitives.AccessPointArn.Type
    object AccessPointId extends Subtype[String]
    type AccessPointId = zio.aws.efs.model.primitives.AccessPointId.Type
    object AvailabilityZoneId extends Subtype[String]
    type AvailabilityZoneId =
      zio.aws.efs.model.primitives.AvailabilityZoneId.Type
    object AvailabilityZoneName extends Subtype[String]
    type AvailabilityZoneName =
      zio.aws.efs.model.primitives.AvailabilityZoneName.Type
    object AwsAccountId extends Subtype[String]
    type AwsAccountId = zio.aws.efs.model.primitives.AwsAccountId.Type
    object Backup extends Subtype[Boolean]
    type Backup = zio.aws.efs.model.primitives.Backup.Type
    object BypassPolicyLockoutSafetyCheck extends Subtype[Boolean]
    type BypassPolicyLockoutSafetyCheck =
      zio.aws.efs.model.primitives.BypassPolicyLockoutSafetyCheck.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.efs.model.primitives.ClientToken.Type
    object CreationToken extends Subtype[String]
    type CreationToken = zio.aws.efs.model.primitives.CreationToken.Type
    object Encrypted extends Subtype[Boolean]
    type Encrypted = zio.aws.efs.model.primitives.Encrypted.Type
    object FileSystemArn extends Subtype[String]
    type FileSystemArn = zio.aws.efs.model.primitives.FileSystemArn.Type
    object FileSystemId extends Subtype[String]
    type FileSystemId = zio.aws.efs.model.primitives.FileSystemId.Type
    object FileSystemNullableSizeValue extends Subtype[Long]
    type FileSystemNullableSizeValue =
      zio.aws.efs.model.primitives.FileSystemNullableSizeValue.Type
    object FileSystemSizeValue extends Subtype[Long]
    type FileSystemSizeValue =
      zio.aws.efs.model.primitives.FileSystemSizeValue.Type
    object Gid extends Subtype[Long]
    type Gid = zio.aws.efs.model.primitives.Gid.Type
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.efs.model.primitives.IpAddress.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.efs.model.primitives.KmsKeyId.Type
    object Marker extends Subtype[String]
    type Marker = zio.aws.efs.model.primitives.Marker.Type
    object MaxItems extends Subtype[Int]
    type MaxItems = zio.aws.efs.model.primitives.MaxItems.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.efs.model.primitives.MaxResults.Type
    object MountTargetCount extends Subtype[Int]
    type MountTargetCount = zio.aws.efs.model.primitives.MountTargetCount.Type
    object MountTargetId extends Subtype[String]
    type MountTargetId = zio.aws.efs.model.primitives.MountTargetId.Type
    object Name extends Subtype[String]
    type Name = zio.aws.efs.model.primitives.Name.Type
    object NetworkInterfaceId extends Subtype[String]
    type NetworkInterfaceId =
      zio.aws.efs.model.primitives.NetworkInterfaceId.Type
    object OwnerGid extends Subtype[Long]
    type OwnerGid = zio.aws.efs.model.primitives.OwnerGid.Type
    object OwnerUid extends Subtype[Long]
    type OwnerUid = zio.aws.efs.model.primitives.OwnerUid.Type
    object Path extends Subtype[String]
    type Path = zio.aws.efs.model.primitives.Path.Type
    object Permissions extends Subtype[String]
    type Permissions = zio.aws.efs.model.primitives.Permissions.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.efs.model.primitives.Policy.Type
    object ProvisionedThroughputInMibps extends Subtype[Double]
    type ProvisionedThroughputInMibps =
      zio.aws.efs.model.primitives.ProvisionedThroughputInMibps.Type
    object RegionName extends Subtype[String]
    type RegionName = zio.aws.efs.model.primitives.RegionName.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.efs.model.primitives.ResourceId.Type
    object SecurityGroup extends Subtype[String]
    type SecurityGroup = zio.aws.efs.model.primitives.SecurityGroup.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.efs.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.efs.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.efs.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.efs.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.efs.model.primitives.Token.Type
    object Uid extends Subtype[Long]
    type Uid = zio.aws.efs.model.primitives.Uid.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.efs.model.primitives.VpcId.Type
  }
  type AccessPointDescriptions = List[zio.aws.efs.model.AccessPointDescription]
  type Destinations = List[zio.aws.efs.model.Destination]
  type DestinationsToCreate = List[zio.aws.efs.model.DestinationToCreate]
  type FileSystemDescriptions = List[zio.aws.efs.model.FileSystemDescription]
  type LifecyclePolicies = List[zio.aws.efs.model.LifecyclePolicy]
  type MountTargetDescriptions = List[zio.aws.efs.model.MountTargetDescription]
  type ReplicationConfigurationDescriptions =
    List[zio.aws.efs.model.ReplicationConfigurationDescription]
  type Resources = List[zio.aws.efs.model.Resource]
  type SecondaryGids = List[Gid]
  type SecurityGroups = List[SecurityGroup]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.efs.model.Tag]
}
