package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BackupPolicy(status: zio.aws.efs.model.Status) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.BackupPolicy = {
    import BackupPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.BackupPolicy
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.BackupPolicy.ReadOnly =
    zio.aws.efs.model.BackupPolicy.wrap(buildAwsValue())
}
object BackupPolicy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.efs.model.BackupPolicy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.BackupPolicy =
      zio.aws.efs.model.BackupPolicy(status)
    def status: zio.aws.efs.model.Status
    def getStatus: ZIO[Any, Nothing, zio.aws.efs.model.Status] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.BackupPolicy
  ) extends zio.aws.efs.model.BackupPolicy.ReadOnly {
    override val status: zio.aws.efs.model.Status =
      zio.aws.efs.model.Status.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.BackupPolicy
  ): zio.aws.efs.model.BackupPolicy.ReadOnly = new Wrapper(impl)
}
