package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.{
  SecurityGroup,
  IpAddress,
  SubnetId,
  FileSystemId
}
import scala.jdk.CollectionConverters._
final case class CreateMountTargetRequest(
    fileSystemId: FileSystemId,
    subnetId: SubnetId,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroup]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.CreateMountTargetRequest = {
    import CreateMountTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.CreateMountTargetRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.CreateMountTargetRequest.ReadOnly =
    zio.aws.efs.model.CreateMountTargetRequest.wrap(buildAwsValue())
}
object CreateMountTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.CreateMountTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.CreateMountTargetRequest =
      zio.aws.efs.model.CreateMountTargetRequest(
        fileSystemId,
        subnetId,
        ipAddress.map(value => value),
        securityGroups.map(value => value)
      )
    def fileSystemId: FileSystemId
    def subnetId: SubnetId
    def ipAddress: Optional[IpAddress]
    def securityGroups: Optional[List[SecurityGroup]]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroup]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.CreateMountTargetRequest
  ) extends zio.aws.efs.model.CreateMountTargetRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val subnetId: SubnetId =
      zio.aws.efs.model.primitives.SubnetId(impl.subnetId())
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.efs.model.primitives.IpAddress(value))
    override val securityGroups: Optional[List[SecurityGroup]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.primitives.SecurityGroup(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.CreateMountTargetRequest
  ): zio.aws.efs.model.CreateMountTargetRequest.ReadOnly = new Wrapper(impl)
}
