package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class CreateReplicationConfigurationRequest(
    sourceFileSystemId: FileSystemId,
    destinations: Iterable[zio.aws.efs.model.DestinationToCreate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationRequest = {
    import CreateReplicationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationRequest
      .builder()
      .sourceFileSystemId(
        FileSystemId.unwrap(sourceFileSystemId): java.lang.String
      )
      .destinations(destinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.CreateReplicationConfigurationRequest.ReadOnly =
    zio.aws.efs.model.CreateReplicationConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateReplicationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.CreateReplicationConfigurationRequest =
      zio.aws.efs.model.CreateReplicationConfigurationRequest(
        sourceFileSystemId,
        destinations.map { item =>
          item.asEditable
        }
      )
    def sourceFileSystemId: FileSystemId
    def destinations: List[zio.aws.efs.model.DestinationToCreate.ReadOnly]
    def getSourceFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(sourceFileSystemId)
    def getDestinations: ZIO[Any, Nothing, List[
      zio.aws.efs.model.DestinationToCreate.ReadOnly
    ]] = ZIO.succeed(destinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationRequest
  ) extends zio.aws.efs.model.CreateReplicationConfigurationRequest.ReadOnly {
    override val sourceFileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.sourceFileSystemId())
    override val destinations
        : List[zio.aws.efs.model.DestinationToCreate.ReadOnly] = impl
      .destinations()
      .asScala
      .map { item =>
        zio.aws.efs.model.DestinationToCreate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationRequest
  ): zio.aws.efs.model.CreateReplicationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
