package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.{Permissions, OwnerGid, OwnerUid}
import scala.jdk.CollectionConverters._
final case class CreationInfo(
    ownerUid: OwnerUid,
    ownerGid: OwnerGid,
    permissions: Permissions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.CreationInfo = {
    import CreationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.CreationInfo
      .builder()
      .ownerUid(OwnerUid.unwrap(ownerUid): java.lang.Long)
      .ownerGid(OwnerGid.unwrap(ownerGid): java.lang.Long)
      .permissions(Permissions.unwrap(permissions): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.CreationInfo.ReadOnly =
    zio.aws.efs.model.CreationInfo.wrap(buildAwsValue())
}
object CreationInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.efs.model.CreationInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.CreationInfo =
      zio.aws.efs.model.CreationInfo(ownerUid, ownerGid, permissions)
    def ownerUid: OwnerUid
    def ownerGid: OwnerGid
    def permissions: Permissions
    def getOwnerUid: ZIO[Any, Nothing, OwnerUid] = ZIO.succeed(ownerUid)
    def getOwnerGid: ZIO[Any, Nothing, OwnerGid] = ZIO.succeed(ownerGid)
    def getPermissions: ZIO[Any, Nothing, Permissions] =
      ZIO.succeed(permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.CreationInfo
  ) extends zio.aws.efs.model.CreationInfo.ReadOnly {
    override val ownerUid: OwnerUid =
      zio.aws.efs.model.primitives.OwnerUid(impl.ownerUid())
    override val ownerGid: OwnerGid =
      zio.aws.efs.model.primitives.OwnerGid(impl.ownerGid())
    override val permissions: Permissions =
      zio.aws.efs.model.primitives.Permissions(impl.permissions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.CreationInfo
  ): zio.aws.efs.model.CreationInfo.ReadOnly = new Wrapper(impl)
}
