package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class DeleteFileSystemRequest(fileSystemId: FileSystemId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest = {
    import DeleteFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DeleteFileSystemRequest.ReadOnly =
    zio.aws.efs.model.DeleteFileSystemRequest.wrap(buildAwsValue())
}
object DeleteFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DeleteFileSystemRequest =
      zio.aws.efs.model.DeleteFileSystemRequest(fileSystemId)
    def fileSystemId: FileSystemId
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest
  ) extends zio.aws.efs.model.DeleteFileSystemRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest
  ): zio.aws.efs.model.DeleteFileSystemRequest.ReadOnly = new Wrapper(impl)
}
