package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeBackupPolicyResponse(
    backupPolicy: Optional[zio.aws.efs.model.BackupPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse = {
    import DescribeBackupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse
      .builder()
      .optionallyWith(backupPolicy.map(value => value.buildAwsValue()))(
        _.backupPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeBackupPolicyResponse.ReadOnly =
    zio.aws.efs.model.DescribeBackupPolicyResponse.wrap(buildAwsValue())
}
object DescribeBackupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeBackupPolicyResponse =
      zio.aws.efs.model.DescribeBackupPolicyResponse(
        backupPolicy.map(value => value.asEditable)
      )
    def backupPolicy: Optional[zio.aws.efs.model.BackupPolicy.ReadOnly]
    def getBackupPolicy
        : ZIO[Any, AwsError, zio.aws.efs.model.BackupPolicy.ReadOnly] =
      AwsError.unwrapOptionField("backupPolicy", backupPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse
  ) extends zio.aws.efs.model.DescribeBackupPolicyResponse.ReadOnly {
    override val backupPolicy
        : Optional[zio.aws.efs.model.BackupPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPolicy())
        .map(value => zio.aws.efs.model.BackupPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse
  ): zio.aws.efs.model.DescribeBackupPolicyResponse.ReadOnly = new Wrapper(impl)
}
