package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.MountTargetId
import scala.jdk.CollectionConverters._
final case class DescribeMountTargetSecurityGroupsRequest(
    mountTargetId: MountTargetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest = {
    import DescribeMountTargetSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest
      .builder()
      .mountTargetId(MountTargetId.unwrap(mountTargetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest.ReadOnly =
    zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeMountTargetSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest =
      zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest(mountTargetId)
    def mountTargetId: MountTargetId
    def getMountTargetId: ZIO[Any, Nothing, MountTargetId] =
      ZIO.succeed(mountTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest
  ) extends zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest.ReadOnly {
    override val mountTargetId: MountTargetId =
      zio.aws.efs.model.primitives.MountTargetId(impl.mountTargetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest
  ): zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
