package zio.aws.efs.model
import zio.aws.efs.model.primitives.{MaxResults, Token, FileSystemId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReplicationConfigurationsRequest(
    fileSystemId: Optional[FileSystemId] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest = {
    import DescribeReplicationConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest
      .builder()
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DescribeReplicationConfigurationsRequest.ReadOnly =
    zio.aws.efs.model.DescribeReplicationConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeReplicationConfigurationsRequest =
      zio.aws.efs.model.DescribeReplicationConfigurationsRequest(
        fileSystemId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def fileSystemId: Optional[FileSystemId]
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest
  ) extends zio.aws.efs.model.DescribeReplicationConfigurationsRequest.ReadOnly {
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.efs.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest
  ): zio.aws.efs.model.DescribeReplicationConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
