package zio.aws.efs.model
import zio.aws.efs.model.primitives.{Timestamp, RegionName, FileSystemId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Destination(
    status: zio.aws.efs.model.ReplicationStatus,
    fileSystemId: FileSystemId,
    region: RegionName,
    lastReplicatedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.efs.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.Destination
      .builder()
      .status(status.unwrap)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .region(RegionName.unwrap(region): java.lang.String)
      .optionallyWith(
        lastReplicatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastReplicatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.Destination.ReadOnly =
    zio.aws.efs.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.efs.model.Destination] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.Destination =
      zio.aws.efs.model.Destination(
        status,
        fileSystemId,
        region,
        lastReplicatedTimestamp.map(value => value)
      )
    def status: zio.aws.efs.model.ReplicationStatus
    def fileSystemId: FileSystemId
    def region: RegionName
    def lastReplicatedTimestamp: Optional[Timestamp]
    def getStatus: ZIO[Any, Nothing, zio.aws.efs.model.ReplicationStatus] =
      ZIO.succeed(status)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getRegion: ZIO[Any, Nothing, RegionName] = ZIO.succeed(region)
    def getLastReplicatedTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastReplicatedTimestamp", lastReplicatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.Destination
  ) extends zio.aws.efs.model.Destination.ReadOnly {
    override val status: zio.aws.efs.model.ReplicationStatus =
      zio.aws.efs.model.ReplicationStatus.wrap(impl.status())
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val region: RegionName =
      zio.aws.efs.model.primitives.RegionName(impl.region())
    override val lastReplicatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastReplicatedTimestamp())
        .map(value => zio.aws.efs.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.Destination
  ): zio.aws.efs.model.Destination.ReadOnly = new Wrapper(impl)
}
