package zio.aws.efs.model
import zio.aws.efs.model.primitives.{Token, MaxResults, ResourceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceId: ResourceId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.efs.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.ListTagsForResourceRequest =
      zio.aws.efs.model.ListTagsForResourceRequest(
        resourceId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceId: ResourceId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest
  ) extends zio.aws.efs.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.efs.model.primitives.ResourceId(impl.resourceId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.efs.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest
  ): zio.aws.efs.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
