package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.{
  SubnetId,
  VpcId,
  AvailabilityZoneId,
  NetworkInterfaceId,
  FileSystemId,
  IpAddress,
  AvailabilityZoneName,
  AwsAccountId,
  MountTargetId
}
import scala.jdk.CollectionConverters._
final case class MountTargetDescription(
    ownerId: Optional[AwsAccountId] = Optional.Absent,
    mountTargetId: MountTargetId,
    fileSystemId: FileSystemId,
    subnetId: SubnetId,
    lifeCycleState: zio.aws.efs.model.LifeCycleState,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    availabilityZoneId: Optional[AvailabilityZoneId] = Optional.Absent,
    availabilityZoneName: Optional[AvailabilityZoneName] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.MountTargetDescription = {
    import MountTargetDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.MountTargetDescription
      .builder()
      .optionallyWith(
        ownerId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .mountTargetId(MountTargetId.unwrap(mountTargetId): java.lang.String)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .lifeCycleState(lifeCycleState.unwrap)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        availabilityZoneId.map(value =>
          AvailabilityZoneId.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneId)
      .optionallyWith(
        availabilityZoneName.map(value =>
          AvailabilityZoneName.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneName)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.MountTargetDescription.ReadOnly =
    zio.aws.efs.model.MountTargetDescription.wrap(buildAwsValue())
}
object MountTargetDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.MountTargetDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.MountTargetDescription =
      zio.aws.efs.model.MountTargetDescription(
        ownerId.map(value => value),
        mountTargetId,
        fileSystemId,
        subnetId,
        lifeCycleState,
        ipAddress.map(value => value),
        networkInterfaceId.map(value => value),
        availabilityZoneId.map(value => value),
        availabilityZoneName.map(value => value),
        vpcId.map(value => value)
      )
    def ownerId: Optional[AwsAccountId]
    def mountTargetId: MountTargetId
    def fileSystemId: FileSystemId
    def subnetId: SubnetId
    def lifeCycleState: zio.aws.efs.model.LifeCycleState
    def ipAddress: Optional[IpAddress]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def availabilityZoneId: Optional[AvailabilityZoneId]
    def availabilityZoneName: Optional[AvailabilityZoneName]
    def vpcId: Optional[VpcId]
    def getOwnerId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getMountTargetId: ZIO[Any, Nothing, MountTargetId] =
      ZIO.succeed(mountTargetId)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getLifeCycleState: ZIO[Any, Nothing, zio.aws.efs.model.LifeCycleState] =
      ZIO.succeed(lifeCycleState)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getAvailabilityZoneId: ZIO[Any, AwsError, AvailabilityZoneId] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getAvailabilityZoneName: ZIO[Any, AwsError, AvailabilityZoneName] =
      AwsError.unwrapOptionField("availabilityZoneName", availabilityZoneName)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.MountTargetDescription
  ) extends zio.aws.efs.model.MountTargetDescription.ReadOnly {
    override val ownerId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.efs.model.primitives.AwsAccountId(value))
    override val mountTargetId: MountTargetId =
      zio.aws.efs.model.primitives.MountTargetId(impl.mountTargetId())
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val subnetId: SubnetId =
      zio.aws.efs.model.primitives.SubnetId(impl.subnetId())
    override val lifeCycleState: zio.aws.efs.model.LifeCycleState =
      zio.aws.efs.model.LifeCycleState.wrap(impl.lifeCycleState())
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.efs.model.primitives.IpAddress(value))
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.efs.model.primitives.NetworkInterfaceId(value))
    override val availabilityZoneId: Optional[AvailabilityZoneId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneId())
        .map(value => zio.aws.efs.model.primitives.AvailabilityZoneId(value))
    override val availabilityZoneName: Optional[AvailabilityZoneName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneName())
        .map(value => zio.aws.efs.model.primitives.AvailabilityZoneName(value))
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.efs.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.MountTargetDescription
  ): zio.aws.efs.model.MountTargetDescription.ReadOnly = new Wrapper(impl)
}
