package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.{Gid, Uid}
import scala.jdk.CollectionConverters._
final case class PosixUser(
    uid: Uid,
    gid: Gid,
    secondaryGids: Optional[Iterable[Gid]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.efs.model.PosixUser = {
    import PosixUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PosixUser
      .builder()
      .uid(Uid.unwrap(uid): java.lang.Long)
      .gid(Gid.unwrap(gid): java.lang.Long)
      .optionallyWith(
        secondaryGids.map(value =>
          value.map { item =>
            Gid.unwrap(item): java.lang.Long
          }.asJavaCollection
        )
      )(_.secondaryGids)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PosixUser.ReadOnly =
    zio.aws.efs.model.PosixUser.wrap(buildAwsValue())
}
object PosixUser {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.efs.model.PosixUser] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PosixUser =
      zio.aws.efs.model.PosixUser(uid, gid, secondaryGids.map(value => value))
    def uid: Uid
    def gid: Gid
    def secondaryGids: Optional[List[Gid]]
    def getUid: ZIO[Any, Nothing, Uid] = ZIO.succeed(uid)
    def getGid: ZIO[Any, Nothing, Gid] = ZIO.succeed(gid)
    def getSecondaryGids: ZIO[Any, AwsError, List[Gid]] =
      AwsError.unwrapOptionField("secondaryGids", secondaryGids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PosixUser
  ) extends zio.aws.efs.model.PosixUser.ReadOnly {
    override val uid: Uid = zio.aws.efs.model.primitives.Uid(impl.uid())
    override val gid: Gid = zio.aws.efs.model.primitives.Gid(impl.gid())
    override val secondaryGids: Optional[List[Gid]] = zio.aws.core.internal
      .optionalFromNullable(impl.secondaryGids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.efs.model.primitives.Gid(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PosixUser
  ): zio.aws.efs.model.PosixUser.ReadOnly = new Wrapper(impl)
}
