package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAccountPreferencesResponse(
    resourceIdPreference: Optional[zio.aws.efs.model.ResourceIdPreference] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse = {
    import PutAccountPreferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse
      .builder()
      .optionallyWith(resourceIdPreference.map(value => value.buildAwsValue()))(
        _.resourceIdPreference
      )
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PutAccountPreferencesResponse.ReadOnly =
    zio.aws.efs.model.PutAccountPreferencesResponse.wrap(buildAwsValue())
}
object PutAccountPreferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PutAccountPreferencesResponse =
      zio.aws.efs.model.PutAccountPreferencesResponse(
        resourceIdPreference.map(value => value.asEditable)
      )
    def resourceIdPreference
        : Optional[zio.aws.efs.model.ResourceIdPreference.ReadOnly]
    def getResourceIdPreference
        : ZIO[Any, AwsError, zio.aws.efs.model.ResourceIdPreference.ReadOnly] =
      AwsError.unwrapOptionField("resourceIdPreference", resourceIdPreference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse
  ) extends zio.aws.efs.model.PutAccountPreferencesResponse.ReadOnly {
    override val resourceIdPreference
        : Optional[zio.aws.efs.model.ResourceIdPreference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdPreference())
        .map(value => zio.aws.efs.model.ResourceIdPreference.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse
  ): zio.aws.efs.model.PutAccountPreferencesResponse.ReadOnly = new Wrapper(
    impl
  )
}
