package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait ResourceIdType {
  def unwrap: software.amazon.awssdk.services.efs.model.ResourceIdType
}
object ResourceIdType {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.ResourceIdType
  ): zio.aws.efs.model.ResourceIdType = value match {
    case software.amazon.awssdk.services.efs.model.ResourceIdType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.ResourceIdType.LONG_ID =>
      val r = LONG_ID
      r
    case software.amazon.awssdk.services.efs.model.ResourceIdType.SHORT_ID =>
      val r = SHORT_ID
      r
  }
  case object unknownToSdkVersion extends zio.aws.efs.model.ResourceIdType {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ResourceIdType =
      software.amazon.awssdk.services.efs.model.ResourceIdType.UNKNOWN_TO_SDK_VERSION
  }
  case object LONG_ID extends zio.aws.efs.model.ResourceIdType {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ResourceIdType =
      software.amazon.awssdk.services.efs.model.ResourceIdType.LONG_ID
  }
  case object SHORT_ID extends zio.aws.efs.model.ResourceIdType {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ResourceIdType =
      software.amazon.awssdk.services.efs.model.ResourceIdType.SHORT_ID
  }
}
