package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey, Timestamp, ClusterName}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Addon(
    addonName: Option[String] = None,
    clusterName: Option[ClusterName] = None,
    status: Option[zio.aws.eks.model.AddonStatus] = None,
    addonVersion: Option[String] = None,
    health: Option[zio.aws.eks.model.AddonHealth] = None,
    addonArn: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    modifiedAt: Option[Timestamp] = None,
    serviceAccountRoleArn: Option[String] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Addon = {
    import Addon.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Addon
      .builder()
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .optionallyWith(
        clusterName.map(value => ClusterName.unwrap(value): java.lang.String)
      )(_.clusterName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(addonVersion.map(value => value: java.lang.String))(
        _.addonVersion
      )
      .optionallyWith(health.map(value => value.buildAwsValue()))(_.health)
      .optionallyWith(addonArn.map(value => value: java.lang.String))(
        _.addonArn
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        modifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedAt)
      .optionallyWith(
        serviceAccountRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccountRoleArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Addon.ReadOnly =
    zio.aws.eks.model.Addon.wrap(buildAwsValue())
}
object Addon {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Addon] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Addon = zio.aws.eks.model.Addon(
      addonName.map(value => value),
      clusterName.map(value => value),
      status.map(value => value),
      addonVersion.map(value => value),
      health.map(value => value.asEditable),
      addonArn.map(value => value),
      createdAt.map(value => value),
      modifiedAt.map(value => value),
      serviceAccountRoleArn.map(value => value),
      tags.map(value => value)
    )
    def addonName: Option[String]
    def clusterName: Option[ClusterName]
    def status: Option[zio.aws.eks.model.AddonStatus]
    def addonVersion: Option[String]
    def health: Option[zio.aws.eks.model.AddonHealth.ReadOnly]
    def addonArn: Option[String]
    def createdAt: Option[Timestamp]
    def modifiedAt: Option[Timestamp]
    def serviceAccountRoleArn: Option[String]
    def tags: Option[Map[TagKey, TagValue]]
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
    def getClusterName: ZIO[Any, AwsError, ClusterName] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.AddonStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAddonVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonVersion", addonVersion)
    def getHealth: ZIO[Any, AwsError, zio.aws.eks.model.AddonHealth.ReadOnly] =
      AwsError.unwrapOptionField("health", health)
    def getAddonArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonArn", addonArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getServiceAccountRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccountRoleArn", serviceAccountRoleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Addon
  ) extends zio.aws.eks.model.Addon.ReadOnly {
    override val addonName: Option[String] =
      scala.Option(impl.addonName()).map(value => value: String)
    override val clusterName: Option[ClusterName] = scala
      .Option(impl.clusterName())
      .map(value => zio.aws.eks.model.primitives.ClusterName(value))
    override val status: Option[zio.aws.eks.model.AddonStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.eks.model.AddonStatus.wrap(value))
    override val addonVersion: Option[String] =
      scala.Option(impl.addonVersion()).map(value => value: String)
    override val health: Option[zio.aws.eks.model.AddonHealth.ReadOnly] = scala
      .Option(impl.health())
      .map(value => zio.aws.eks.model.AddonHealth.wrap(value))
    override val addonArn: Option[String] =
      scala.Option(impl.addonArn()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val modifiedAt: Option[Timestamp] = scala
      .Option(impl.modifiedAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val serviceAccountRoleArn: Option[String] =
      scala.Option(impl.serviceAccountRoleArn()).map(value => value: String)
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Addon
  ): zio.aws.eks.model.Addon.ReadOnly = new Wrapper(impl)
}
