package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddonIssue(
    code: Option[zio.aws.eks.model.AddonIssueCode] = None,
    message: Option[String] = None,
    resourceIds: Option[Iterable[String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.AddonIssue = {
    import AddonIssue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AddonIssue
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIds)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.AddonIssue.ReadOnly =
    zio.aws.eks.model.AddonIssue.wrap(buildAwsValue())
}
object AddonIssue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.AddonIssue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AddonIssue = zio.aws.eks.model.AddonIssue(
      code.map(value => value),
      message.map(value => value),
      resourceIds.map(value => value)
    )
    def code: Option[zio.aws.eks.model.AddonIssueCode]
    def message: Option[String]
    def resourceIds: Option[List[String]]
    def getCode: ZIO[Any, AwsError, zio.aws.eks.model.AddonIssueCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getResourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceIds", resourceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AddonIssue
  ) extends zio.aws.eks.model.AddonIssue.ReadOnly {
    override val code: Option[zio.aws.eks.model.AddonIssueCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.eks.model.AddonIssueCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val resourceIds: Option[List[String]] = scala
      .Option(impl.resourceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AddonIssue
  ): zio.aws.eks.model.AddonIssue.ReadOnly = new Wrapper(impl)
}
