package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class CreateFargateProfileRequest(
    fargateProfileName: String,
    clusterName: String,
    podExecutionRoleArn: String,
    subnets: Option[Iterable[String]] = None,
    selectors: Option[Iterable[zio.aws.eks.model.FargateProfileSelector]] =
      None,
    clientRequestToken: Option[String] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateFargateProfileRequest = {
    import CreateFargateProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateFargateProfileRequest
      .builder()
      .fargateProfileName(fargateProfileName: java.lang.String)
      .clusterName(clusterName: java.lang.String)
      .podExecutionRoleArn(podExecutionRoleArn: java.lang.String)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        selectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectors)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateFargateProfileRequest.ReadOnly =
    zio.aws.eks.model.CreateFargateProfileRequest.wrap(buildAwsValue())
}
object CreateFargateProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateFargateProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateFargateProfileRequest =
      zio.aws.eks.model.CreateFargateProfileRequest(
        fargateProfileName,
        clusterName,
        podExecutionRoleArn,
        subnets.map(value => value),
        selectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        tags.map(value => value)
      )
    def fargateProfileName: String
    def clusterName: String
    def podExecutionRoleArn: String
    def subnets: Option[List[String]]
    def selectors
        : Option[List[zio.aws.eks.model.FargateProfileSelector.ReadOnly]]
    def clientRequestToken: Option[String]
    def tags: Option[Map[TagKey, TagValue]]
    def getFargateProfileName: ZIO[Any, Nothing, String] =
      ZIO.succeed(fargateProfileName)
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getPodExecutionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(podExecutionRoleArn)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSelectors: ZIO[Any, AwsError, List[
      zio.aws.eks.model.FargateProfileSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("selectors", selectors)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateFargateProfileRequest
  ) extends zio.aws.eks.model.CreateFargateProfileRequest.ReadOnly {
    override val fargateProfileName: String = impl.fargateProfileName(): String
    override val clusterName: String = impl.clusterName(): String
    override val podExecutionRoleArn: String =
      impl.podExecutionRoleArn(): String
    override val subnets: Option[List[String]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val selectors
        : Option[List[zio.aws.eks.model.FargateProfileSelector.ReadOnly]] =
      scala
        .Option(impl.selectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.FargateProfileSelector.wrap(item)
          }.toList
        )
    override val clientRequestToken: Option[String] =
      scala.Option(impl.clientRequestToken()).map(value => value: String)
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateFargateProfileRequest
  ): zio.aws.eks.model.CreateFargateProfileRequest.ReadOnly = new Wrapper(impl)
}
