package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFargateProfileRequest(
    clusterName: String,
    fargateProfileName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeleteFargateProfileRequest = {
    import DeleteFargateProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeleteFargateProfileRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .fargateProfileName(fargateProfileName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeleteFargateProfileRequest.ReadOnly =
    zio.aws.eks.model.DeleteFargateProfileRequest.wrap(buildAwsValue())
}
object DeleteFargateProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeleteFargateProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeleteFargateProfileRequest =
      zio.aws.eks.model
        .DeleteFargateProfileRequest(clusterName, fargateProfileName)
    def clusterName: String
    def fargateProfileName: String
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getFargateProfileName: ZIO[Any, Nothing, String] =
      ZIO.succeed(fargateProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeleteFargateProfileRequest
  ) extends zio.aws.eks.model.DeleteFargateProfileRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val fargateProfileName: String = impl.fargateProfileName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeleteFargateProfileRequest
  ): zio.aws.eks.model.DeleteFargateProfileRequest.ReadOnly = new Wrapper(impl)
}
