package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeClusterRequest(name: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeClusterRequest = {
    import DescribeClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeClusterRequest
      .builder()
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeClusterRequest.ReadOnly =
    zio.aws.eks.model.DescribeClusterRequest.wrap(buildAwsValue())
}
object DescribeClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeClusterRequest =
      zio.aws.eks.model.DescribeClusterRequest(name)
    def name: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeClusterRequest
  ) extends zio.aws.eks.model.DescribeClusterRequest.ReadOnly {
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeClusterRequest
  ): zio.aws.eks.model.DescribeClusterRequest.ReadOnly = new Wrapper(impl)
}
