package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeFargateProfileRequest(
    clusterName: String,
    fargateProfileName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest = {
    import DescribeFargateProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .fargateProfileName(fargateProfileName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeFargateProfileRequest.ReadOnly =
    zio.aws.eks.model.DescribeFargateProfileRequest.wrap(buildAwsValue())
}
object DescribeFargateProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeFargateProfileRequest =
      zio.aws.eks.model
        .DescribeFargateProfileRequest(clusterName, fargateProfileName)
    def clusterName: String
    def fargateProfileName: String
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getFargateProfileName: ZIO[Any, Nothing, String] =
      ZIO.succeed(fargateProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest
  ) extends zio.aws.eks.model.DescribeFargateProfileRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val fargateProfileName: String = impl.fargateProfileName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest
  ): zio.aws.eks.model.DescribeFargateProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
