package zio.aws.eks.model
import java.time.Instant
import zio.aws.eks.model.primitives.{
  LabelKey,
  Timestamp,
  TagValue,
  BoxedInteger,
  LabelValue,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Nodegroup(
    nodegroupName: Option[String] = None,
    nodegroupArn: Option[String] = None,
    clusterName: Option[String] = None,
    version: Option[String] = None,
    releaseVersion: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    modifiedAt: Option[Timestamp] = None,
    status: Option[zio.aws.eks.model.NodegroupStatus] = None,
    capacityType: Option[zio.aws.eks.model.CapacityTypes] = None,
    scalingConfig: Option[zio.aws.eks.model.NodegroupScalingConfig] = None,
    instanceTypes: Option[Iterable[String]] = None,
    subnets: Option[Iterable[String]] = None,
    remoteAccess: Option[zio.aws.eks.model.RemoteAccessConfig] = None,
    amiType: Option[zio.aws.eks.model.AMITypes] = None,
    nodeRole: Option[String] = None,
    labels: Option[Map[LabelKey, LabelValue]] = None,
    taints: Option[Iterable[zio.aws.eks.model.Taint]] = None,
    resources: Option[zio.aws.eks.model.NodegroupResources] = None,
    diskSize: Option[BoxedInteger] = None,
    health: Option[zio.aws.eks.model.NodegroupHealth] = None,
    updateConfig: Option[zio.aws.eks.model.NodegroupUpdateConfig] = None,
    launchTemplate: Option[zio.aws.eks.model.LaunchTemplateSpecification] =
      None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Nodegroup = {
    import Nodegroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Nodegroup
      .builder()
      .optionallyWith(nodegroupName.map(value => value: java.lang.String))(
        _.nodegroupName
      )
      .optionallyWith(nodegroupArn.map(value => value: java.lang.String))(
        _.nodegroupArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(releaseVersion.map(value => value: java.lang.String))(
        _.releaseVersion
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        modifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedAt)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(capacityType.map(value => value.unwrap))(_.capacityType)
      .optionallyWith(scalingConfig.map(value => value.buildAwsValue()))(
        _.scalingConfig
      )
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(remoteAccess.map(value => value.buildAwsValue()))(
        _.remoteAccess
      )
      .optionallyWith(amiType.map(value => value.unwrap))(_.amiType)
      .optionallyWith(nodeRole.map(value => value: java.lang.String))(
        _.nodeRole
      )
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (LabelKey.unwrap(key): java.lang.String) -> (LabelValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .optionallyWith(
        taints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taints)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(diskSize.map(value => value: Integer))(_.diskSize)
      .optionallyWith(health.map(value => value.buildAwsValue()))(_.health)
      .optionallyWith(updateConfig.map(value => value.buildAwsValue()))(
        _.updateConfig
      )
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Nodegroup.ReadOnly =
    zio.aws.eks.model.Nodegroup.wrap(buildAwsValue())
}
object Nodegroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Nodegroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Nodegroup = zio.aws.eks.model.Nodegroup(
      nodegroupName.map(value => value),
      nodegroupArn.map(value => value),
      clusterName.map(value => value),
      version.map(value => value),
      releaseVersion.map(value => value),
      createdAt.map(value => value),
      modifiedAt.map(value => value),
      status.map(value => value),
      capacityType.map(value => value),
      scalingConfig.map(value => value.asEditable),
      instanceTypes.map(value => value),
      subnets.map(value => value),
      remoteAccess.map(value => value.asEditable),
      amiType.map(value => value),
      nodeRole.map(value => value),
      labels.map(value => value),
      taints.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      resources.map(value => value.asEditable),
      diskSize.map(value => value),
      health.map(value => value.asEditable),
      updateConfig.map(value => value.asEditable),
      launchTemplate.map(value => value.asEditable),
      tags.map(value => value)
    )
    def nodegroupName: Option[String]
    def nodegroupArn: Option[String]
    def clusterName: Option[String]
    def version: Option[String]
    def releaseVersion: Option[String]
    def createdAt: Option[Timestamp]
    def modifiedAt: Option[Timestamp]
    def status: Option[zio.aws.eks.model.NodegroupStatus]
    def capacityType: Option[zio.aws.eks.model.CapacityTypes]
    def scalingConfig: Option[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly]
    def instanceTypes: Option[List[String]]
    def subnets: Option[List[String]]
    def remoteAccess: Option[zio.aws.eks.model.RemoteAccessConfig.ReadOnly]
    def amiType: Option[zio.aws.eks.model.AMITypes]
    def nodeRole: Option[String]
    def labels: Option[Map[LabelKey, LabelValue]]
    def taints: Option[List[zio.aws.eks.model.Taint.ReadOnly]]
    def resources: Option[zio.aws.eks.model.NodegroupResources.ReadOnly]
    def diskSize: Option[BoxedInteger]
    def health: Option[zio.aws.eks.model.NodegroupHealth.ReadOnly]
    def updateConfig: Option[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly]
    def launchTemplate
        : Option[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getNodegroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodegroupName", nodegroupName)
    def getNodegroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodegroupArn", nodegroupArn)
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getReleaseVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseVersion", releaseVersion)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.NodegroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCapacityType: ZIO[Any, AwsError, zio.aws.eks.model.CapacityTypes] =
      AwsError.unwrapOptionField("capacityType", capacityType)
    def getScalingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.NodegroupScalingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("scalingConfig", scalingConfig)
    def getInstanceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getRemoteAccess
        : ZIO[Any, AwsError, zio.aws.eks.model.RemoteAccessConfig.ReadOnly] =
      AwsError.unwrapOptionField("remoteAccess", remoteAccess)
    def getAmiType: ZIO[Any, AwsError, zio.aws.eks.model.AMITypes] =
      AwsError.unwrapOptionField("amiType", amiType)
    def getNodeRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeRole", nodeRole)
    def getLabels: ZIO[Any, AwsError, Map[LabelKey, LabelValue]] =
      AwsError.unwrapOptionField("labels", labels)
    def getTaints: ZIO[Any, AwsError, List[zio.aws.eks.model.Taint.ReadOnly]] =
      AwsError.unwrapOptionField("taints", taints)
    def getResources
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupResources.ReadOnly] =
      AwsError.unwrapOptionField("resources", resources)
    def getDiskSize: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("diskSize", diskSize)
    def getHealth
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupHealth.ReadOnly] =
      AwsError.unwrapOptionField("health", health)
    def getUpdateConfig
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] =
      AwsError.unwrapOptionField("updateConfig", updateConfig)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Nodegroup
  ) extends zio.aws.eks.model.Nodegroup.ReadOnly {
    override val nodegroupName: Option[String] =
      scala.Option(impl.nodegroupName()).map(value => value: String)
    override val nodegroupArn: Option[String] =
      scala.Option(impl.nodegroupArn()).map(value => value: String)
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val releaseVersion: Option[String] =
      scala.Option(impl.releaseVersion()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val modifiedAt: Option[Timestamp] = scala
      .Option(impl.modifiedAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.eks.model.NodegroupStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.eks.model.NodegroupStatus.wrap(value))
    override val capacityType: Option[zio.aws.eks.model.CapacityTypes] = scala
      .Option(impl.capacityType())
      .map(value => zio.aws.eks.model.CapacityTypes.wrap(value))
    override val scalingConfig
        : Option[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly] = scala
      .Option(impl.scalingConfig())
      .map(value => zio.aws.eks.model.NodegroupScalingConfig.wrap(value))
    override val instanceTypes: Option[List[String]] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val subnets: Option[List[String]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val remoteAccess
        : Option[zio.aws.eks.model.RemoteAccessConfig.ReadOnly] = scala
      .Option(impl.remoteAccess())
      .map(value => zio.aws.eks.model.RemoteAccessConfig.wrap(value))
    override val amiType: Option[zio.aws.eks.model.AMITypes] = scala
      .Option(impl.amiType())
      .map(value => zio.aws.eks.model.AMITypes.wrap(value))
    override val nodeRole: Option[String] =
      scala.Option(impl.nodeRole()).map(value => value: String)
    override val labels: Option[Map[LabelKey, LabelValue]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .LabelKey(key) -> zio.aws.eks.model.primitives.LabelValue(value)
          })
          .toMap
      )
    override val taints: Option[List[zio.aws.eks.model.Taint.ReadOnly]] = scala
      .Option(impl.taints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eks.model.Taint.wrap(item)
        }.toList
      )
    override val resources
        : Option[zio.aws.eks.model.NodegroupResources.ReadOnly] = scala
      .Option(impl.resources())
      .map(value => zio.aws.eks.model.NodegroupResources.wrap(value))
    override val diskSize: Option[BoxedInteger] =
      scala.Option(impl.diskSize()).map(value => value: BoxedInteger)
    override val health: Option[zio.aws.eks.model.NodegroupHealth.ReadOnly] =
      scala
        .Option(impl.health())
        .map(value => zio.aws.eks.model.NodegroupHealth.wrap(value))
    override val updateConfig
        : Option[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] = scala
      .Option(impl.updateConfig())
      .map(value => zio.aws.eks.model.NodegroupUpdateConfig.wrap(value))
    override val launchTemplate
        : Option[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly] = scala
      .Option(impl.launchTemplate())
      .map(value => zio.aws.eks.model.LaunchTemplateSpecification.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Nodegroup
  ): zio.aws.eks.model.Nodegroup.ReadOnly = new Wrapper(impl)
}
