package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterClusterResponse(
    cluster: Option[zio.aws.eks.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.RegisterClusterResponse = {
    import RegisterClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.RegisterClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.RegisterClusterResponse.ReadOnly =
    zio.aws.eks.model.RegisterClusterResponse.wrap(buildAwsValue())
}
object RegisterClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.RegisterClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.RegisterClusterResponse =
      zio.aws.eks.model
        .RegisterClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.eks.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.eks.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.RegisterClusterResponse
  ) extends zio.aws.eks.model.RegisterClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.eks.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.eks.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.RegisterClusterResponse
  ): zio.aws.eks.model.RegisterClusterResponse.ReadOnly = new Wrapper(impl)
}
