package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateClusterConfigResponse(
    update: Option[zio.aws.eks.model.Update] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateClusterConfigResponse = {
    import UpdateClusterConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateClusterConfigResponse
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateClusterConfigResponse.ReadOnly =
    zio.aws.eks.model.UpdateClusterConfigResponse.wrap(buildAwsValue())
}
object UpdateClusterConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateClusterConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateClusterConfigResponse =
      zio.aws.eks.model
        .UpdateClusterConfigResponse(update.map(value => value.asEditable))
    def update: Option[zio.aws.eks.model.Update.ReadOnly]
    def getUpdate: ZIO[Any, AwsError, zio.aws.eks.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateClusterConfigResponse
  ) extends zio.aws.eks.model.UpdateClusterConfigResponse.ReadOnly {
    override val update: Option[zio.aws.eks.model.Update.ReadOnly] = scala
      .Option(impl.update())
      .map(value => zio.aws.eks.model.Update.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateClusterConfigResponse
  ): zio.aws.eks.model.UpdateClusterConfigResponse.ReadOnly = new Wrapper(impl)
}
