package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait UpdateStatus {
  def unwrap: software.amazon.awssdk.services.eks.model.UpdateStatus
}
object UpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.UpdateStatus
  ): zio.aws.eks.model.UpdateStatus = value match {
    case software.amazon.awssdk.services.eks.model.UpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.UpdateStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.eks.model.UpdateStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.eks.model.UpdateStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.eks.model.UpdateStatus.SUCCESSFUL =>
      val r = Successful
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateStatus =
      software.amazon.awssdk.services.eks.model.UpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.eks.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateStatus =
      software.amazon.awssdk.services.eks.model.UpdateStatus.IN_PROGRESS
  }
  case object Failed extends zio.aws.eks.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateStatus =
      software.amazon.awssdk.services.eks.model.UpdateStatus.FAILED
  }
  case object Cancelled extends zio.aws.eks.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateStatus =
      software.amazon.awssdk.services.eks.model.UpdateStatus.CANCELLED
  }
  case object Successful extends zio.aws.eks.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateStatus =
      software.amazon.awssdk.services.eks.model.UpdateStatus.SUCCESSFUL
  }
}
