package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateTaintsPayload(
    addOrUpdateTaints: Option[Iterable[zio.aws.eks.model.Taint]] = None,
    removeTaints: Option[Iterable[zio.aws.eks.model.Taint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateTaintsPayload = {
    import UpdateTaintsPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateTaintsPayload
      .builder()
      .optionallyWith(
        addOrUpdateTaints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOrUpdateTaints)
      .optionallyWith(
        removeTaints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeTaints)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateTaintsPayload.ReadOnly =
    zio.aws.eks.model.UpdateTaintsPayload.wrap(buildAwsValue())
}
object UpdateTaintsPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateTaintsPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateTaintsPayload =
      zio.aws.eks.model.UpdateTaintsPayload(
        addOrUpdateTaints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeTaints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def addOrUpdateTaints: Option[List[zio.aws.eks.model.Taint.ReadOnly]]
    def removeTaints: Option[List[zio.aws.eks.model.Taint.ReadOnly]]
    def getAddOrUpdateTaints
        : ZIO[Any, AwsError, List[zio.aws.eks.model.Taint.ReadOnly]] =
      AwsError.unwrapOptionField("addOrUpdateTaints", addOrUpdateTaints)
    def getRemoveTaints
        : ZIO[Any, AwsError, List[zio.aws.eks.model.Taint.ReadOnly]] =
      AwsError.unwrapOptionField("removeTaints", removeTaints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateTaintsPayload
  ) extends zio.aws.eks.model.UpdateTaintsPayload.ReadOnly {
    override val addOrUpdateTaints
        : Option[List[zio.aws.eks.model.Taint.ReadOnly]] = scala
      .Option(impl.addOrUpdateTaints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eks.model.Taint.wrap(item)
        }.toList
      )
    override val removeTaints: Option[List[zio.aws.eks.model.Taint.ReadOnly]] =
      scala
        .Option(impl.removeTaints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.Taint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateTaintsPayload
  ): zio.aws.eks.model.UpdateTaintsPayload.ReadOnly = new Wrapper(impl)
}
